<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title"><?php echo e(__('lang.admin_contact_us_list')); ?></h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th><?php echo e(__('lang.admin_menu_users')); ?></th>
                               <th><?php echo e(__('lang.admin_email')); ?></th>
                               <th><?php echo e(__('lang.admin_mobile')); ?></th>
                               <th><?php echo e(__('lang.admin_message')); ?></th>
                               <th><?php echo e(__('lang.admin_date')); ?></th>
                               <th><?php echo e(__('lang.admin_status')); ?></th>
                               <th><?php echo e(__('lang.admin_table_action')); ?></th>
                           </tr>
                       </thead>
                       <tbody>
                           <?php if(count($data) > 0): ?>
                           <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <tr>
                                <td><?php echo e(isset($res->name)?$res->name:'--'); ?></td>
                                <td><?php echo e(isset($res->email)?$res->email:'--'); ?></td>
                                <td><?php echo e(isset($res->mobile)?$res->mobile:'--'); ?></td>
                                <td><?php echo e(isset($res->message)?$res->message:'--'); ?></td>
                                <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateFormate($res->created_at) : '--'); ?></td>
                                <td><?php if($res->is_replied == 1): ?>
                                    <span class="badge rounded-pill badge-light-success me-1"><?php echo e(__('lang.admin_replied')); ?></span>
                                    <?php else: ?> 
                                    --
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a data-bs-toggle="modal" data-bs-target="#modals-slide-in_<?php echo e($res->id); ?>" data-placement="bottom" title="<?php echo e(__('lang.admin_reply')); ?>" class='on-default edit-row margin-3'>
                                        <i data-feather="send" class="me-50"></i>
                                    </a>
                                    <div class="modal modal-slide-in fade" id="modals-slide-in_<?php echo e($res->id); ?>">
                                        <div class="modal-dialog sidebar-sm">
                                            <form class="add-new-record modal-content pt-0" action="<?php echo route('contact_us.store'); ?>" enctype="multipart/form-data" method="post">
                                                <input type="hidden" class="form-control dt-full-name" aria-label="Contact" name="contact_id" value="<?php echo e($res->id); ?>"/>
                                                <?php echo csrf_field(); ?>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                                <div class="modal-header mb-1">
                                                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('lang.admin_reply')); ?></h5>
                                                </div>
                                                <div class="modal-body flex-grow-1">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-fullname"><?php echo e(__('lang.admin_user_name')); ?></label>
                                                        <input type="text" class="form-control dt-full-name"  id="basic-icon-default-fullname" placeholder="<?php echo e(__('lang.admin_name')); ?>" aria-label="<?php echo e(__('lang.admin_name')); ?>" name="name" value="<?php echo e(isset($res->name)?$res->name:'--'); ?>"/>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-discount_price"><?php echo e(__('lang.admin_email')); ?></label>
                                                        <input type="email" id="basic-icon-default-discount_price" class="form-control dt-discount_price" placeholder="<?php echo e(__('lang.admin_email')); ?>" aria-label="<?php echo e(__('lang.admin_email')); ?>" name="email" value="<?php echo e(isset($res->email)?$res->email:'--'); ?>" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="message"><?php echo e(__('lang.admin_message')); ?></label>
                                                        <textarea id="fp-default" class="form-control flatpickr-basic" placeholder="<?php echo e(__('lang.admin_message')); ?>" aria-label="<?php echo e(__('lang.admin_message')); ?>" name="message"></textarea>
                                                    </div>
                                                    <button type="submit" class="btn btn-primary data-submit me-1"><?php echo e(__('lang.admin_button_submit')); ?></button>
                                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('lang.admin_button_cancel')); ?></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                </td>
                           </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           <?php else: ?>
                           <tr>
                               <td colspan="6" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                           </tr>
                           <?php endif; ?>
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
<?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/contact_us/table.blade.php ENDPATH**/ ?>