
<?php $__env->startSection('content'); ?>
<!-- BEGIN: Content-->

<link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css/pages/dashboard-ecommerce.css')); ?>">
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="<?php echo e(asset('app-assets/vendors/js/charts/apexcharts.min.js')); ?>"></script>
<script src="<?php echo e(asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')); ?>"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')); ?>" />

<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <!-- Dashboard Ecommerce Starts -->
            <section id="dashboard-ecommerce">
                <div class="row match-height">
                    <div class="col-xl-12 col-md-6 col-12">
                        <div class="card card-statistics">
                            <div class="card-header">
                                <h4 class="card-title"><?php echo e(__('lang.admin_dashboard_statistics')); ?></h4>
                                <div class="d-flex align-items-center">
                                    <p class="card-text font-small-2 me-25 mb-0"><?php echo e(__('lang.admin_dashboard_updated_at')); ?> <?php echo e(\Helpers::commonDateTimeFormate(date("Y-m-d H:i:s"))); ?></p>
                                </div>
                            </div>
                            <div class="card-body statistics-body">
                                <div class="row">
                                    <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                        <a href="<?php echo route('orders.index'); ?>">
                                            <div class="d-flex flex-row">
                                                <div class="avatar bg-light-info me-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="trending-up" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="my-auto">
                                                <h4 class="fw-bolder mb-0"><?php echo e(!empty($response['sales']) ? \Helpers::currency($response['sales']) : 0); ?></h4>
                                                    <p class="card-text font-small-3 mb-0"><?php echo e(__('lang.admin_dashboard_total_order_amnt')); ?></p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                        <a href="<?php echo route('users.index'); ?>">
                                            <div class="d-flex flex-row">
                                                <div class="avatar bg-light-danger me-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="user" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="my-auto">
                                                <h4 class="fw-bolder mb-0"><?php echo e(!empty($response['customers']) ? $response['customers'] : 0); ?></h4>
                                                    <p class="card-text font-small-3 mb-0"><?php echo e(__('lang.admin_dashboard_total_users')); ?></p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                        <a href="<?php echo url('admin/delivery'); ?>?order_date=<?php echo e($response['pending_orders_date']); ?>&submit=Search">
                                            <div class="d-flex flex-row">
                                                <div class="avatar bg-light-primary me-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="truck" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="my-auto">
                                                    <h4 class="fw-bolder mb-0"><?php echo e(!empty($response['pending_orders']) ? $response['pending_orders'] : 0); ?></h4>
                                                    <p class="card-text font-small-3 mb-0"><?php echo e(__('lang.admin_dashboard_pending_orders_at')); ?> <?php echo e(\Helpers::commonDateFormate($response['pending_orders_date'])); ?></p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-xl-3 col-sm-6 col-12">
                                        <a href="<?php echo url('admin/subscription'); ?>">
                                            <div class="d-flex flex-row">
                                                <div class="avatar bg-light-success me-2">
                                                    <div class="avatar-content">
                                                        <i data-feather="shopping-bag" class="avatar-icon"></i>
                                                    </div>
                                                </div>
                                                <div class="my-auto">
                                                    <h4 class="fw-bolder mb-0"><?php echo e(!empty($response['active_subscription']) ? $response['active_subscription'] : 0); ?></h4>
                                                    <p class="card-text font-small-3 mb-0"><?php echo e(__('lang.admin_menu_active_subscription')); ?></p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Statistics Card -->
                </div>

                <div class="row match-height">
                    <section id="apexchart">
                        <div class="row">
                    <!-- Area Chart starts -->
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header d-flex flex-sm-row flex-column justify-content-md-between align-items-start justify-content-start">
                                        <div>
                                            <h4 class="card-title"><?php echo e(__('lang.admin_dashboard_chart')); ?></h4>
                                            <span class="card-subtitle text-muted"><?php echo e(__('lang.admin_dashboard_user_and_orders')); ?></span>
                                        </div>
                                        <form>
                                            <?php echo csrf_field(); ?>
                                            <div class="d-flex align-items-center">
                                                <i class="font-medium-2" data-feather="calendar"></i>
                                                <input type="text" class="form-control flat-picker bg-transparent border-0 shadow-none" placeholder="YYYY-MM-DD" name="date_range" />
                                                <button type="submit" class="btn btn-primary data-submit"><i class="font-medium-2" data-feather="search"></i></button>
                                            </div>
                                    </form>
                                    </div>
                                    <div class="card-body">
                                        <div id="line-area-chart"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>

                <!-- List DataTable -->
                <div class="content-body">
                    <!-- Striped rows start -->
                    <div class="row" id="table-striped">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title"><?php echo e(__('lang.admin_dashboard_recent_orders_list')); ?></h4>
                                    <h6 style="float: right;"><a href="<?php echo e(route('orders.index')); ?>"><?php echo e(__('lang.admin_dashboard_view_all')); ?></a></h6>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('lang.admin_order_id')); ?></th>
                                                <th><?php echo e(__('lang.admin_user_phone')); ?></th>
                                                <th><?php echo e(__('lang.admin_order_status')); ?></th>
                                                <th><?php echo e(__('lang.admin_amount')); ?></th>
                                                <th><?php echo e(__('lang.admin_method')); ?></th>
                                                <th><?php echo e(__('lang.admin_payment_status')); ?></th>
                                                <th><?php echo e(__('lang.admin_date')); ?></th>
                                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if(count($data) > 0): ?>
                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><a title="Order Detail" href="<?php echo e(route('orders.show', $res->id)); ?>">#<?php echo e($res->id); ?></a></td>
                                                <td><?php echo e(isset($res->user)?$res->user->phone:'--'); ?></td>
                                                <td><?php echo e(isset($res->order_status) ? $res->order_status->status : '--'); ?></td>
                                                <td><?php echo e(isset($res->final_amount) ? \Helpers::currency($res->final_amount) : '--'); ?></td>
                                                <td style="text-transform: capitalize;"><?php echo e(isset($res->payment_method) ? $res->payment_method : '--'); ?></td>
                                                <td>
                                                    <?php if(isset($res->payment)): ?>
                                                        <?php echo \Helpers::showPaymentStatus($res->payment->status) ?>
                                                    <?php else: ?>
                                                     --
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e((isset($res->created_at)) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                                <td><div class="dropdown">
                                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                            <i data-feather="more-vertical"></i>
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="<?php echo e(route('orders.show', $res->id)); ?>">
                                                                <i data-feather="eye" class="me-50"></i>
                                                                <span><?php echo e(__('lang.admin_button_detail')); ?></span>
                                                            </a>
                                                            <a class="dropdown-item" href="<?php echo e(route('orders.edit', $res->id)); ?>">
                                                                <i data-feather="edit-2" class="me-50"></i>
                                                                <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                                            </a>
                                                            <?php echo Form::open(['route' => ['orders.destroy', $res->id], 'method' => 'delete']); ?>

                                                            <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                                'data-toggle' => 'tooltip',
                                                                'data-placement' => 'bottom',
                                                                'title' => 'Delete',
                                                                'type' => 'submit',
                                                                'class' => 'dropdown-item',
                                                                'onclick' => "return confirm('Are you sure?')",
                                                                'style' => "width:100%;"
                                                            ]); ?>

                                                            <?php echo Form::close(); ?>

                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                            <tr>
                                                <td colspan="8" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Striped rows end -->
                </div>
                <!--/ List DataTable -->
            </section>
            <!-- Dashboard Ecommerce ends -->

        </div>
    </div>
</div>
<script type="text/javascript">
var flatPicker = $(".flat-picker");
var date = new Date();
flatPicker.each(function () {
    $(this).flatpickr({
        mode: "range",
        defaultDate: ["<?php echo e($response['chart_start_date']); ?>", "<?php echo e($response['chart_end_date']); ?>"],
    });
});

var chartColors = {
    area: {
        series3: "#14a1a7",
        series2: "#7a3402"
    }
};
var areaChartEl = document.querySelector("#line-area-chart"),
    areaChartConfig = {
        chart: {
            height: 400,
            type: "area",
            parentHeightOffset: 0,
            toolbar: {
                show: false,
            },
        },
        dataLabels: {
            enabled: false,
        },
        stroke: {
            show: false,
            curve: "straight",
        },
        legend: {
            show: true,
            position: "top",
            horizontalAlign: "start",
        },
        grid: {
            xaxis: {
                lines: {
                    show: true,
                },
            },
        },
        colors: [chartColors.area.series3, chartColors.area.series2],
        series: [
            {
                name: "Order",
                data: <?php echo json_encode($response['order_count']); ?>,
            },
            {
                name: "Users",
                data: <?php echo json_encode($response['user_count']); ?>,
            }
        ],
        xaxis: {
            categories: <?php echo json_encode($response['date_range']); ?>,
        },
        fill: {
            opacity: 1,
            type: "solid",
        },
        tooltip: {
            shared: true,
        },
        yaxis: {
            opposite: false,
        },
    };
if (typeof areaChartEl !== undefined && areaChartEl !== null) {
    var areaChart = new ApexCharts(areaChartEl, areaChartConfig);
    areaChart.render();
}

</script>
<!-- END: Content-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/waterfl/public_html/resources/views/dashboard/index.blade.php ENDPATH**/ ?>