<div class="card card-employee-task">
    <div class="card-header">
        <h4 class="card-title"><?php echo e(__('lang.admin_order_info')); ?></h4>
    </div>
    <div class="card-body">
        <div class="transaction-item">
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title"><?php echo e(__('lang.admin_order')); ?> #:</h6>
                    <small><?php echo e(isset($data->id) ? $data->id : '--'); ?></small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title"><?php echo e(__('lang.admin_order_date')); ?>:</h6>
                    <small><?php echo e(isset($data->created_at) ? \Helpers::commonDateTimeFormate($data->created_at) : '--'); ?></small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title"><?php echo e(__('lang.admin_amount')); ?>:</h6>
                    <small><?php echo e(isset($data->final_amount) ? \Helpers::currency($data->final_amount) : '--'); ?></small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title"><?php echo e(__('lang.admin_payment_method')); ?>:</h6>
                    <small><?php echo e(isset($data->payment_method) ? $data->payment_method : '--'); ?></small>
                </div>
            </div>
            <hr>
            <div class="d-flex">
                <div class="transaction-percentage">
                    <h6 class="transaction-title"><?php echo e(__('lang.admin_timeslot')); ?>:</h6>
                    <small><?php if(isset($data->time_slots)): ?> <b><?php echo e($data->time_slots->name); ?></b> <?php echo e(date('h:i A',strtotime($data->time_slots->from_time))); ?> - <?php echo e(date('h:i A',strtotime($data->time_slots->to_time))); ?> <?php endif; ?></small>
                </div>
            </div>
        </div>  
    </div>
</div><?php /**PATH /home/waterfl/public_html/resources/views/orders/order-info.blade.php ENDPATH**/ ?>