
<?php $__env->startSection('content'); ?>
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0"><?php echo e(__('lang.admin_user_wallet')); ?></h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo route('dashboard'); ?>"><?php echo e(__('lang.admin_menu_dashboard')); ?></a>
                                </li>
                                <li class="breadcrumb-item"><a href="<?php echo route('users.index'); ?>"><?php echo e(__('lang.admin_user_list')); ?></a></li>
                                <li class="breadcrumb-item active"><?php echo e(__('lang.admin_user_wallet')); ?></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span><?php echo e(__('lang.admin_user_wallet_add')); ?></span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- Striped rows start -->
            <div class="row" id="table-striped">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title"><?php echo e($user->phone); ?> <?php echo e(__('lang.admin_wallet_list')); ?></h4>
                            <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('lang.admin_table_sno')); ?></th>
                                        <th><?php echo e(__('lang.admin_type')); ?></th>
                                        <th><?php echo e(__('lang.admin_amount')); ?></th>
                                        <th><?php echo e(__('lang.admin_description')); ?></th>
                                        <th><?php echo e(__('lang.admin_created_at')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=0; ?>
                                    <?php if(count($data) > 0): ?>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php $i++; ?>
                                    <tr>
                                        <td><?php echo e($i); ?></td>
                                        <td>
                                            <?php if($res->type == 'credit'): ?>
                                                <a href="javascript:;">
                                                    <span class="badge rounded-pill badge-light-primary me-1">Credit</span>
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:;">
                                                    <span class="badge rounded-pill badge-light-warning me-1">Debit</span>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(isset($res->amount) ? \Helpers::currency($res->amount) : '--'); ?></td>
                                        <td><?php echo e(isset($res->description)?$res->description:'--'); ?> <?php if($res->order_info): ?> Please click on <a href="<?php echo e(route('orders.show', $res->order_info->id)); ?>" target="_blank"><b class="nocolor">#<?php echo e($res->order_info->id); ?></b></a>  <?php endif; ?></td>
                                        <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <div class="pagination" style="float: right;">
                                <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Striped rows end -->
        </div>
    </div>
</div>

<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="<?php echo url('admin/users/wallet/transaction/'.$user->id); ?>" method="post">
            <?php echo csrf_field(); ?>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('lang.admin_payment_gateway_wallet')); ?></h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="type"><?php echo e(__('lang.admin_type')); ?></label>
                    <select class="form-select" id="type" name="type">
                        <option value="credit"><?php echo e(__('lang.admin_credit')); ?></option>
                        <option value="debit"><?php echo e(__('lang.admin_debit')); ?></option>
                    </select>
                    <small class="form-text"> <?php echo e(__('lang.admin_wallet_text')); ?></small>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname"><?php echo e(__('lang.admin_wallet_amnt')); ?> <span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="100.00*" aria-label="100.00" name="amount" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-phone"><?php echo e(__('lang.admin_wallet_description')); ?> <span class="required">*</span></label>
                    <textarea id="basic-icon-default-phone" class="form-control dt-post" placeholder="Wallet Description *" aria-label="Wallet Description" name="description" required></textarea>
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1"><?php echo e(__('lang.admin_button_submit')); ?></button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('lang.admin_button_cancel')); ?></button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/users/wallet.blade.php ENDPATH**/ ?>