<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title"><?php echo e(__('lang.admin_push_noti_list')); ?></h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th><?php echo e(__('lang.admin_image')); ?></th>
                               <th><?php echo e(__('lang.admin_title')); ?></th>
                               <th><?php echo e(__('lang.admin_description')); ?></th>
                               <th><?php echo e(__('lang.admin_date')); ?></th>
                               <th><?php echo e(__('lang.admin_table_action')); ?></th>
                           </tr>
                       </thead>
                       <tbody>
                           <?php if(count($data) > 0): ?>
                           <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <tr>
                                <td aria-colindex="2" role="cell" class="">
                                    <span class="b-avatar mr-1 badge-secondary rounded-circle">
                                        <span class="b-avatar-img">
                                            <?php if($res->image!=''): ?>
                                                <img src="<?php echo e(asset('/app-assets/images/notification/'.$res->image)); ?>" width="100px" onerror="this.src='<?php echo e(asset('app-assets/images/no-image.png')); ?>';">
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('/app-assets/images/no-image.png')); ?>">
                                            <?php endif; ?>
                                        </span>
                                    </span>
                                </td>
                                <td><?php echo e(isset($res->title)?$res->title:'--'); ?></td>
                                <td><?php echo e(isset($res->description)?$res->description:'--'); ?></td>
                                <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <?php echo Form::open(['route' => ['notifications.destroy', $res->id], 'method' => 'delete']); ?>

                                            <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                'data-toggle' => 'tooltip',
                                                'data-placement' => 'bottom',
                                                'title' => 'Delete',
                                                'type' => 'submit',
                                                'class' => 'dropdown-item',
                                                'onclick' => "return confirm('Are you sure?')",
                                                'style' => "width:100%;"
                                            ]); ?>

                                            <?php echo Form::close(); ?>

                                        </div>
                                    </div>
                                </td>
                           </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           <?php else: ?>
                           <tr>
                               <td colspan="3" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                           </tr>
                           <?php endif; ?>
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
<?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/notifications/table.blade.php ENDPATH**/ ?>