<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_active_subscription_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo e(__('lang.admin_user_phone')); ?></th>
                                <th><?php echo e(__('lang.admin_order_item_name')); ?></th>
                                <th><?php echo e(__('lang.admin_order_delivery')); ?></th>
                                <th><?php echo e(__('lang.admin_order_delivery_date')); ?></th>
                                <th><?php echo e(__('lang.admin_start_date')); ?></th>
                                <th><?php echo e(__('lang.admin_end_date')); ?></th>
                                <th><?php echo e(__('lang.admin_price')); ?></th>
                                <th><?php echo e(__('lang.admin_order_quantity')); ?></th>
                                <th><?php echo e(__('lang.admin_amount')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i); ?></td>
                                <td><?php echo e(isset($res->user)?$res->user->phone:'--'); ?></td>
                                <td><?php echo e(isset($res->product->name)?$res->product->name:'--'); ?></td>
                                <td style="text-transform: capitalize;"><?php echo e(isset($res->order_frequency) ? $res->order_frequency : '--'); ?></td>
                                <?php if($res->order_frequency == 'once'): ?>
                                <td>
                                    <?php if(isset($res->end_date)): ?>
                                        <?php echo e(\Helpers::commonDateFormate($res->end_date)); ?>

                                    <?php else: ?>
                                        <?php if($res->product_deliverys): ?>
                                            <?php if(isset($res->product_deliverys[count($res->product_deliverys)-1])): ?>
                                                <?php echo e(\Helpers::commonDateFormate($res->product_deliverys[count($res->product_deliverys)-1]->delivery_date)); ?>

                                            <?php else: ?>
                                                --
                                            <?php endif; ?>
                                        <?php else: ?>
                                            --
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <?php else: ?> 
                                <td>
                                    <button class="dropdown-item" data-bs-toggle="modal" data-bs-target="#modalsDates_<?php echo e($res->id); ?>">
                                        <i data-feather="eye" class="me-50"></i>
                                        <span><?php echo e(__('lang.admin_dashboard_view_all')); ?></span>
                                    </button>
                                    <div class="modal fade text-start" id="modalsDates_<?php echo e($res->id); ?>" tabindex="-1" aria-labelledby="myModalLabel160" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-xs">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel160"><?php echo e(__('lang.admin_order_delivery_date')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php $__currentLoopData = $res->product_deliverys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deliveries): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <ul class="list-group">
                                                        <li class="list-group-item"><?php echo e(\Helpers::commonDateFormate($deliveries->delivery_date)); ?> <small class="text-right"><?php echo e($deliveries->delivery_status->status); ?></small></li>
                                                    </ul>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <?php endif; ?>
                                <td>
                                    <?php if(isset($res->start_date)): ?>
                                        <?php echo e(\Helpers::commonDateFormate($res->start_date)); ?>

                                    <?php else: ?>
                                        <?php if(isset($res->product_deliverys[0])): ?>
                                            <?php echo e(\Helpers::commonDateFormate($res->product_deliverys[0]->delivery_date)); ?>

                                        <?php else: ?>
                                            --
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(isset($res->end_date)): ?>
                                        <?php echo e(\Helpers::commonDateFormate($res->end_date)); ?>

                                    <?php else: ?>
                                        <?php if($res->product_deliverys): ?>
                                            <?php if(isset($res->product_deliverys[count($res->product_deliverys)-1])): ?>
                                                <?php echo e(\Helpers::commonDateFormate($res->product_deliverys[count($res->product_deliverys)-1]->delivery_date)); ?>

                                            <?php else: ?>
                                                --
                                            <?php endif; ?>
                                        <?php else: ?>
                                            --
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(\Helpers::currency($res->per_delivery_amount)); ?></td>
                                <td><?php echo e($res->quantity); ?></td>
                                <td><?php echo e(\Helpers::currency($res->total_delivery_amount)); ?></td>
                            </tr>
                            <?php $i++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="10" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/orders/active_subscription_table.blade.php ENDPATH**/ ?>