<!-- Basic table -->
<section id="responsive-datatable">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title"><?php echo e(__('lang.admin_banner_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                </div>
                <div class="card-datatable">
                    <table class="dt-responsive table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_image')); ?></th>
                                <th><?php echo e(__('lang.admin_type')); ?></th>
                                <th><?php echo e(__('lang.admin_title')); ?></th>
                                <th><?php echo e(__('lang.admin_subtitle')); ?></th>
                                <th><?php echo e(__('lang.admin_status')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td aria-colindex="2" role="cell" class=""><span class="b-avatar mr-1 badge-secondary rounded-circle"><span class="b-avatar-img">
                                    <?php if($res->image!=''): ?>
                                        <img src="<?php echo e(asset('/app-assets/images/banners/'.$res->image)); ?>" width="100px" onerror="this.src='<?php echo e(asset('app-assets/images/no-image.png')); ?>';">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('/app-assets/images/no-image.png')); ?>">
                                    <?php endif; ?>
                                </span></span></td>
                                <td style="text-transform: capitalize"><?php echo e(isset($res->banner_type)?$res->banner_type:'--'); ?></td>
                                <td><?php echo e(isset($res->title)?$res->title:'--'); ?></td>
                                <td><?php echo e(isset($res->sub_title)?$res->sub_title:'--'); ?></td>
                                <td>
                                    <?php if($res->status == 1): ?>
                                    <a href="<?php echo e(url('admin/change-banner-status/'.$res->id)); ?>">
                                        <span class="badge rounded-pill badge-light-primary me-1"><?php echo e(__('lang.admin_active')); ?></span></a>
                                    <?php else: ?>
                                    <a href="<?php echo e(url('admin/change-banner-status/'.$res->id)); ?>">
                                        <span class="badge rounded-pill badge-light-warning me-1"><?php echo e(__('lang.admin_deactive')); ?></span></a>
                                    <?php endif; ?>
                                </td>
                                <td><div class="dropdown">
                                    <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i data-feather="more-vertical"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('banners.edit', $res->id)); ?>">
                                            <i data-feather="edit-2" class="me-50"></i>
                                            <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                        </a>
                                        <a class="dropdown-item" href="<?php echo e(url('admin/banners/translation/'.$res->id)); ?>">
                                            <i data-feather="type" class="me-50"></i>
                                            <span><?php echo e(__('lang.admin_button_translation')); ?></span>
                                        </a>
                                        <?php echo Form::open(['route' => ['banners.destroy', $res->id], 'method' => 'delete']); ?>

                                            <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                'data-toggle' => 'tooltip',
                                                'data-placement' => 'bottom',
                                                'title' => 'Delete',
                                                'type' => 'submit',
                                                'class' => 'dropdown-item',
                                                'onclick' => "return confirm('Are you sure?')",
                                                'style' => "width:100%;"
                                            ]); ?>

                                            <?php echo Form::close(); ?>

                                    </div>
                                </div></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="4" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH /home/waterfl/public_html/resources/views/banners/table.blade.php ENDPATH**/ ?>