<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Banners;
use App\Models\BannerTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class BannerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Banners::getLists();
        return view('banners.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/banners/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }
        Banners::create($input);
        Session::flash('success', 'Banner created successfully!'); 
        return redirect()->route('banners.index')
                        ->with('success','Banner created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $banner = Banners::find($id);    
        return view('banners.edit',compact('banner'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $banner = Banners::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/banners/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }
        $banner->update($input);
        Session::flash('success', 'Banner updated successfully!'); 
        return redirect()->route('banners.index')
                        ->with('success','Banner updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Banners::find($id)->delete();
        Session::flash('success', 'Banner deleted successfully!');
        return redirect()->route('banners.index')
                        ->with('success','Banner deleted successfully');
    }

    public function translation($id)
    {
        $data = Banners::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = BannerTranslation::where('banner_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'banner_id' => $id,
                    'lang_code' => $row->language_code,
                    'title' => $data->title,
                    'sub_title' => $data->sub_title,
                    'created_at' => date("Y-m-d H:i:s")
                );
                BannerTranslation::insert($postData);
                $row->details = BannerTranslation::where('banner_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('banners.translation',compact('data'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'title' => 'required',
            'sub_title' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'title'        => $input['title'][$i],
                    'sub_title'    => $input['sub_title'][$i]
                );
                Banners::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'title' => $input['title'][$i],
                'sub_title' => $input['sub_title'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            BannerTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }
        
        Session::flash('success', 'Translation updated successfully!');
        return redirect()->route('banners.index')
                        ->with('success','Translation updated successfully.');
    }

    public function changeStatus($id){
        $data = Banners::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('banners.index')
                        ->with('success','Status change successfully');
    }
}
