<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Contactus;
use App\Models\User;

class ContactUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Contactus::getLists();
        return view('contact_us.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        
        $emailData = array(             
            'app_name'=>"Website",
            'username'=> $input['name'], 
            'mail_signature'=> "Support Team", 
            'reply_text'=> $input['message'], 
            "logo" => url('/app-assets/images/logo.png')
        );

        \Mail::send('email.contact-reply', $emailData, function($message){
            $email = setting('contact_email');
            $subject = 'You got a reply from support team';
            $message->to($email, 'Test')->subject
               ($subject);
            $message->from("socialtechnofox@gmail.com","Support");
        });
        $status_update = array(
            'is_replied' => 1
        );
        Contactus::where('id',$input['contact_id'])->update($status_update);
        return redirect()->route('contact_us.index')
                        ->with('success','Reply send successfully');
    }
}
