<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\OrderProduct;
use App\Models\OrderProductsDelivery;
use App\Models\Order;
use Illuminate\Support\Facades\DB;
class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $post = $request->all();
        $response = array();
        $tommorowDate = date("Y-m-d",strtotime("+1 day"));
        $response['sales'] = Order::sum('final_amount');
        $response['customers'] = User::where('type','user')->count();
        $response['pending_orders'] = OrderProductsDelivery::where('delivery_date',$tommorowDate)->where('order_status_id',1)->count();
        $response['pending_orders_date'] = $tommorowDate;
        $response['active_subscription'] = OrderProduct::where('end_date',">=",date("Y-m-d"))->where('order_frequency','!=','once')->count();

        $response['date_range'] = array();
        $response['order_count'] = array();
        $response['user_count'] = array();
        if(isset($post['date_range'])){
            $date = explode("to",$post['date_range']);
            $response['chart_start_date'] = (isset($date[0]))?date("Y-m-d",strtotime(trim($date[0]))):date("Y-m-01");
            $response['chart_end_date'] = (isset($date[1]))?date("Y-m-d",strtotime(trim($date[1]))):date("Y-m-01");
        }else{
            $response['chart_start_date'] = date("Y-m-01");
            $response['chart_end_date']  = date("Y-m-d");
        }

        $i = 0;
        $currentDate = $response['chart_start_date'];
        do{
            array_push($response['date_range'], date("d M",strtotime($response['chart_start_date'].' + '.$i.' day')));
            $orderCount = Order::where(DB::raw("DATE(created_at)"), '=', date("Y-m-d",strtotime($response['chart_start_date'].' + '.$i.' day')))->count();
            array_push($response['order_count'],$orderCount);
            $userCount = User::where('type','user')->where(DB::raw("DATE(created_at)"), '=', date("Y-m-d",strtotime($response['chart_start_date'].' + '.$i.' day')))->count();
            array_push($response['user_count'],$userCount);
            $currentDate = date("d M",strtotime($response['chart_start_date'].' + '.$i.' day'));
            $i++;
        }while(strtotime($currentDate)<strtotime($response['chart_end_date']));

        $latestOrder = Order::getLatest();

        return view('dashboard.index')->with('response',$response)->with('data',$latestOrder);
    }
}
