<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\LanguagesKeywords;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class LanguagesKeywordsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $post = $request->all();
        $language = Languages::getLists();
        $data = LanguagesKeywords::getLists($post);
        return view('keywords.index',compact('data'))->with('language',$language);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = LanguagesKeywords::where('keyword',$id)->where('lang_code','en')->first();
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = LanguagesKeywords::where('keyword',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'lang_code' => $row->language_code,
                    'group' => $data->group,
                    'keyword' => $data->keyword,
                    'value' => $data->value,
                    'created_at' => date("Y-m-d H:i:s")
                );
                LanguagesKeywords::insert($postData);
                $row->details = LanguagesKeywords::where('keyword',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('keywords.edit',compact('languages'))->with('id',$id);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'keyword_value' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'value' => $input['keyword_value'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            LanguagesKeywords::where(array('lang_code' => $input['language_code'][$i],'keyword'=>$input['keyword']))->update($postData);
        }
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $lang) {
            $data = "<?php
                return [
                    /*
                    |--------------------------------------------------------------------------
                    | Pagination Language Lines
                    |--------------------------------------------------------------------------
                    |
                    | The following language lines are used by the paginator library to build
                    | the simple pagination links. You are free to change them to anything
                    | you want to customize your views to better match your application.
                    |
                    */
            ";
            $translations = LanguagesKeywords::whereIn('group',['web','admin'])->where('lang_code',$lang->language_code)->get();
            foreach ($translations as $row) {
                $row->value = str_replace("'", "",$row->value);
                $data .= "'".$row->keyword."' => '".$row->value."',\n";
            }
            $data .= "];";

            $fp = fopen('resources/lang/'.$lang->language_code.'/lang.php', 'w');
            fwrite($fp, $data);
            fclose($fp);
        }
        Session::flash('success', 'Languages keywords updated successfully!');
        return redirect()->route('keywords.index')
                        ->with('success','Languages keywords updated successfully.');
    }
}
