<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\ProductTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $products = Product::getLists();
        return view('products.index',compact('products'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required',
            'price' => 'required'
        ]);
        $input = $request->all();

        if($input['discount_price']!=''){
            if($input['discount_price']>$input['price']){
                Session::flash('error', 'Discount price should be less then or equal to base price.');
                return redirect()->back()->with('error','Discount price should be less then or equal to base price.');
            }
        }

        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/products/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }
        Product::create($input);
        Session::flash('success', 'Product created successfully!');
        return redirect()->route('products.index')
                        ->with('success','Product created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $product = Product::find($id);    
        return view('products.edit',compact('product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $product = Product::find($id);

        if($input['discount_price']!=''){
            if($input['discount_price']>$input['price']){
                Session::flash('error', 'Discount price should be less then or equal to base price.');
                return redirect()->back()->with('error','Discount price should be less then or equal to base price.');
            }
        }

        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/products/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }
        
        $product->update($input);
        Session::flash('success', 'Product updated successfully!');
        return redirect()->route('products.index')
                        ->with('success','Product updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Product::find($id)->delete();
        Session::flash('success', 'Product deleted successfully!');
        return redirect()->route('products.index')
                        ->with('success','Product deleted successfully');
    }

    public function translation($id)
    {
        $data = Product::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = ProductTranslation::where('product_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'product_id' => $id,
                    'lang_code' => $row->language_code,
                    'name' => $data->name,
                    'description' => $data->description,
                    'created_at' => date("Y-m-d H:i:s")
                );
                ProductTranslation::insert($postData);
                $row->details = ProductTranslation::where('product_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('products.translation',compact('data'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'name' => 'required',
            'description' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'name' => $input['name'][$i],
                    'description'  => $input['description'][$i]
                );
                Product::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'name' => $input['name'][$i],
                'description' => $input['description'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            ProductTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }
        
        Session::flash('success', 'Translation updated successfully!');
        return redirect()->route('products.index')
                        ->with('success','Translation updated successfully.');
    }

    public function changeStatus($id){
        $data = Product::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('products.index')
                        ->with('success','Status change successfully');
    }
}
