<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\App;

class SiteAuthenticate
{
    
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  ...$guards
     * @return mixed
     */
    public function handle(Request $request, Closure $next, ...$guards)
    {   
        if (Session()->has('locale') AND array_key_exists(Session()->get('locale'), config('languages'))) {
            App::setLocale(Session()->get('locale'));
        }
        else { // This is optional as Laravel will automatically set the fallback language if there is none specified
            App::setLocale(config('app.fallback_locale'));
        }
        if (Auth::check()) {
            if(Auth::user()->type=='user'){
                return $next($request);
            }else{
                return redirect('/signin');    
            }
        }else{
            return redirect('/signin');
        }
    }
}
