<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class LanguagesKeywords extends Model
{
    use HasFactory;

    public $table = 'keyword_translations';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'lang_code',
        'group',
        'keyword',
        'value'
    ];

    public static function getLists($search)
    {
        try {
            $query = new Self;
            
            if(isset($search['lang_code'])){
                $query = $query->where('lang_code',$search['lang_code']);
            }else{
                $query = $query->where('lang_code','en');
            }

            if(isset($search['search'])  && $search['search'] != ''){
                $keyword = $search['search'];
                $query = $query->where(function($q) use ($keyword){
                    $q->where(DB::raw('keyword'), 'like', '%'.strtolower($keyword). '%')
                    ->orWhere(DB::raw('value'), 'like', '%'.strtolower($keyword). '%');
                });
            }

            if(isset($search['group']) && $search['group']!=''){
                $query = $query->where('group',$search['group']);
            }
            $data = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
            return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
