<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderCancelRequest extends Model
{
    use HasFactory;

    public $table = 'order_cancel_request';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $fillable = [
        'user_id',
        'order_id',
        'refund_amount',
        'refund_status',
        'status'
    ];

    public static function getLists()
    {
        try {
            $query = new Self;
            if(isset($_GET['submit'])){

                if(isset($_GET['status']) && $_GET['status']!=''){
                    $query = $query->where('status',$_GET['status']);
                }
                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }
                return $query->with("order")->with("user")->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));
            }else{
                $data = $query->with('order')->with('user')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
                return $data;
            }
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }


    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    public function order()
    {
        return $this->hasOne('\App\Models\Order','id','order_id');
    }
}
