<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderProduct extends Model
{
    use HasFactory;

    public $table = 'orders_products';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'product_id',
        'order_id',
        'price',
        'quantity',
        'total_price'
    ];

    public function product()
    {
        return $this->hasOne('\App\Models\Product','id','product_id')->withTrashed();
    }

    public function product_deliverys()
    {
        return $this->hasMany('\App\Models\OrderProductsDelivery','product_order_id','id')->with('delivery_status');
    }

    public function order()
    {
        return $this->hasOne('\App\Models\Order','id','order_id');
    }

    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }
    
    public static function getActiveSubscrpition($search){
        try {
            $query = new Self;
            $data = $query->with("user")->with('product')->with('product_deliverys')->with('order')->where('end_date',">=",date("Y-m-d"))->where('order_frequency','!=','once')->paginate(config('constant.paginate.num_per_page'));
            return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
