<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAuthLogin extends Model
{
    use HasFactory;

    public $table = 'user_auth_login';

    public function user(){
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'api_token',
        'device_token',
        'device_type'
    ];
}
