<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Coupon;
use App\Models\CouponTranslation;
use DB;

class CouponAPIController extends Controller
{
    protected $num_per_page = '10';
    private $language;
    public function __construct(Request $request)
    {
        parent::__construct();
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
    }

    public function couponLists(Request $request)
    {
        try{
            
            $allcodes = Coupon::where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('status',1)->get();
            foreach ($allcodes as $row) {
                $translated_data = CouponTranslation::where('lang_code',$this->language)->where('coupon_id',$row['id'])->first();
                if($translated_data){
                    if($translated_data->coupon_name!=''){
                        $row['coupon_name'] = $translated_data->coupon_name;
                    }
                    if($translated_data->description!=''){
                        $row['description'] = $translated_data->description;
                    }
                }
            }
            return $this->sendResponse($allcodes, 'Coupon retrieved successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

     public function assignedCoupons(Request $request)
 {
       
        $token = $request->input('token');

       $user_id  = DB::table('user_auth_login')->where('api_token',$token)->first()->user_id;
        $data = [];
        if($user_id > 0)
        {

            try
            {
               $cou_book = DB::table('coupon_book')->where('assigned',$user_id)->get();
               foreach($cou_book as $cb)
               {
                $new_data = ['book_no'=>$cb->book_no,'status'=>$cb->status,'book_id'=>$cb->id];
                $data[] = $new_data;
               }

               return response()->json($data); 

            }
            catch (\Exception $e) {
    
                return response()->json(['error' => 'error in fetching data'], 500);
            }

            

        }
        else
        {
            return response()->json(['error' => 'Unauthorised user'], 500);
        }

    }

   

    public function assignedCouponSheet(Request $request)
 {
       
        $token = $request->input('token');

       $user_id  = DB::table('user_auth_login')->where('api_token',$token)->first()->user_id;
        $data = [];
        if($user_id > 0)
        {

            try
            {
                $book_id = $request->input('book_id');
               $cou_book = DB::table('coupon')->where('book_id',$book_id)->get();
               foreach($cou_book as $cb)
               {
                $new_data = ['coupon_no'=>$cb->coupon_number,'status'=>$cb->status,'redeemed_on'=>$cb->redeemed_on];
                $data[] = $new_data;
               }

               return response()->json($data); 

            }
            catch (\Exception $e) {
    
                return response()->json(['error' => 'error in fetching data'], 500);
            }

            

        }
        else
        {
            return response()->json(['error' => 'Unauthorised user'], 500);
        }

    }

    public function doVerifyCode(Request $request)
    {
        try{
            
            $allcodes = Coupon::where('coupon_name',$request->input('code'))->where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('status',1)->orderBy('id','DESC')->first();
            if($allcodes){
                return $this->sendResponse($allcodes, 'Coupon retrieved successfully');    
            }else{
                return $this->sendError('Coupon not found', 401);
            }
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }
}
