<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Product;
use App\Models\ProductTranslation;
use App\Models\Cart;
use App\Models\Banners;
use App\Models\BannerTranslation;
use DB;

class ProductAPIController extends Controller
{
    
    protected $num_per_page = '10';
    private $language;
    public function __construct(Request $request)
    {
        parent::__construct();
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
    }

    public function index(Request $request)
    {
        try{

            $response = array(
                'banners' => Banners::where('status',1)->where('banner_type','app')->get(),
                'products' => array()
            );
            
            foreach ($response['banners'] as $bannerRow) {
                $translated_data = BannerTranslation::where('lang_code',$this->language)->where('banner_id',$bannerRow['id'])->first();
                if($translated_data){
                    if($translated_data->title!=''){
                        $bannerRow['title'] = $translated_data->title;
                    }
                    if($translated_data->sub_title!=''){
                        $bannerRow['sub_title'] = $translated_data->sub_title;
                    }
                }
            }

            $user_id = 0;
            $headerData = ($request->header('api-token')? $request->header('api-token'):$request->header('api-token'));
            $tokenData = \Helpers::velidateAuthToken($headerData);
            if ($tokenData) {
                $request->userAuthData = $tokenData;
                if($request->userAuthData){
                    $user_id = $request->userAuthData->user_id;
                }
            }
            
            $allproducts = Product::where('status',1)->get();            
            foreach ($allproducts as $row) {
                $row['cart_info'] = Cart::where('user_id',$user_id)->where('product_id',$row['id'])->first();
                $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$row['id'])->first();
                if($translated_data){
                    if($translated_data->name!=''){
                        $row['name'] = $translated_data->name;
                    }
                    if($translated_data->description!=''){
                        $row['description'] = $translated_data->description;
                    }
                }
            }
            $response['products'] = $allproducts;
            return $this->sendResponse($response, 'Products retrieved successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function productDetails($id,Request $request)
    {
        try{
            
            $user_id = 0;
            $headerData = ($request->header('api-token')? $request->header('api-token'):$request->header('api-token'));
            $tokenData = \Helpers::velidateAuthToken($headerData);
            if ($tokenData) {
                $request->userAuthData = $tokenData;
                if($request->userAuthData){
                    $user_id = $request->userAuthData->user_id;
                }
            }
            
            $row = Product::where('id',$id)->first();
            $row['cart_info'] = Cart::where('user_id',$user_id)->where('product_id',$row['id'])->first();
            $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$row['id'])->first();
            if($translated_data){
                if($translated_data->name!=''){
                    $row['name'] = $translated_data->name;
                }
                if($translated_data->description!=''){
                    $row['description'] = $translated_data->description;
                }
            }
            return $this->sendResponse($row, 'Products retrieved successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function search(Request $request)
    {
        try{
            $post = $request->all();
            $user_id = 0;
            $headerData = ($request->header('api-token')? $request->header('api-token'):$request->header('api-token'));
            $tokenData = \Helpers::velidateAuthToken($headerData);
            if ($tokenData) {
                $request->userAuthData = $tokenData;
                if($request->userAuthData){
                    $user_id = $request->userAuthData->user_id;
                }
            }
            
            $searchedProducts = Product::where('status',1)->where(DB::raw('lower(name)'), 'like', '%' .strtolower($post['search']). '%')->get();            
            foreach ($searchedProducts as $row) {
                $row['cart_info'] = Cart::where('user_id',$user_id)->where('product_id',$row['id'])->first();
                $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$row['id'])->first();
                if($translated_data){
                    if($translated_data->name!=''){
                        $row['name'] = $translated_data->name;
                    }
                    if($translated_data->description!=''){
                        $row['description'] = $translated_data->description;
                    }
                }
            }
            $response = $searchedProducts;
            return $this->sendResponse($response, 'Products retrieved successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }
}
