@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-body">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_delivery_areas')}}</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a
                                            href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                    <li class="breadcrumb-item active">{{__('lang.admin_delivery_area_list')}}
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                    <div class="mb-1 breadcrumb-right">
                        <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal"
                            data-bs-target="#modals-slide-in">
                            <i data-feather="plus" class="me-25"></i>
                            <span>{{__('lang.admin_delivery_area_add')}}</span>
                        </button>
                    </div>
                </div>
            </div>
            @include('delivery_areas.table')
        </div>
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('delivery_areas.store') !!}"
            enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_delivery_area_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <input type="hidden" name="country" id="country" value="<?php echo (isset($data->country))?$data->country:'' ?>">
                <input type="hidden" name="city" id="city" value="<?php echo (isset($data->city))?$data->city:'' ?>">
                <input type="hidden" name="region" id="region" value="<?php echo (isset($data->region))?$data->region:'' ?>">
                <div class="mb-1">
                    <label class="form-label" for="location_name">{{__('lang.admin_location_name')}}</label>
                    <input type="text" class="form-control dt-full-name" id="location_name" placeholder="{{__('lang.admin_location_name')}}" aria-label="{{__('lang.admin_location_name')}}" name="location_name" autocomplete="off" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="zip_code">{{__('lang.admin_zip_code')}}</label>
                    <input type="text" class="form-control dt-full-name" id="zip_code" placeholder="{{__('lang.admin_zip_code')}}" aria-label="{{__('lang.admin_zip_code')}}" name="zip_code" readonly/>
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
<script type="text/javascript">
    setTimeout(function(){
        googleAutoComplete(); 
    },1000);
</script>
@endsection