<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_driver_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_image')}}</th>
                                <th>{{__('lang.admin_name')}}</th>
                                <th>{{__('lang.admin_email')}}</th>
                                <th>{{__('lang.admin_phone')}}</th>
                                <th>{{__('lang.admin_status')}}</th>
                                <th>{{__('lang.admin_created_at')}}</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td aria-colindex="2" role="cell" class=""><span class="b-avatar mr-1 badge-secondary rounded-circle"><span class="b-avatar-img">
                                    @if($res->image!='')
                                    <img src="{{asset('/app-assets/images/drivers/'.$res->image)}}" width="100px" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';">
                                    @else
                                    <img src="{{asset('/app-assets/images/no-image.png')}}">
                                    @endif
                                </span></span></td>
                                <td>{{ isset($res->name)?$res->name:'--' }}</td>
                                <td>{{ isset($res->email)?$res->email:'--' }}</td>
                                <td>{{ isset($res->phone)?$res->phone:'--' }}</td>
                                <td>
                                    @if($res->status == 1)
                                        <a href="{{ url('admin/change-driver-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-primary me-1">{{__('lang.admin_active')}}</span></a>
                                    @else
                                        <a href="{{ url('admin/change-driver-status/'.$res->id) }}">
                                            <span class="badge rounded-pill badge-light-warning me-1">{{__('lang.admin_deactive')}}</span></a>
                                    @endif
                                </td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('drivers.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            {!! Form::open(['route' => ['drivers.destroy', $res->id], 'method' => 'delete']) !!}
                                            {!! Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                'data-toggle' => 'tooltip',
                                                'data-placement' => 'bottom',
                                                'title' => 'Delete',
                                                'type' => 'submit',
                                                'class' => 'dropdown-item',
                                                'onclick' => "return confirm('Are you sure?')",
                                                'style' => "width:100%;"
                                            ]) !!}
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>