<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_holiday_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}}
                        {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_start_date')}}</th>
                                <th>{{__('lang.admin_end_date')}}</th>
                                <th>{{__('lang.admin_description')}}</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td>{{ isset($res->start_date) ? \Helpers::commonDateFormate($res->start_date) : '--' }}</td>
                                <td>{{ isset($res->end_date) ? \Helpers::commonDateFormate($res->end_date) : '--' }}</td>
                                <td>{{$res->description}}</td>
                                <td>@if($res->start_date > date('Y-m-d H:i:s'))
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" data-bs-toggle="modal"
                                                data-bs-target="#edit_non_working_days_{{$res->id}}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            {!! Form::open(['route' => ['holidays.destroy', $res->id], 'method'
                                            =>
                                            'delete']) !!}
                                            {!! Form::button('<i data-feather="trash"
                                                class="me-50"></i><span>Delete</span>', [
                                            'data-toggle' => 'tooltip',
                                            'data-placement' => 'bottom',
                                            'title' => 'Delete',
                                            'type' => 'submit',
                                            'class' => 'dropdown-item',
                                            'onclick' => "return confirm('Are you sure?')",
                                            'style' => "width:100%;"
                                            ]) !!}
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                    <!-- Modal to add new record -->
                                    <div class="modal modal-slide-in fade" id="edit_non_working_days_{{$res->id}}">
                                        <div class="modal-dialog sidebar-sm">
                                            {!! Form::model($data, ['method' =>
                                            'PATCH','enctype'=>'multipart/form-data', 'route' =>
                                            ['holidays.update',
                                            $res->id],'class'=> 'add-new-record modal-content pt-0']) !!}
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close">×</button>
                                            <div class="modal-header mb-1">
                                                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_holiday_update')}}</h5>
                                            </div>
                                            <div class="modal-body flex-grow-1">
                                                <div class="mb-1">
                                                    <?php $date = array();
                                                array_push($date, $res->start_date);
                                                array_push($date, $res->end_date);
                                                $date_range = implode(" to ",$date);
                                                    ?>
                                                    <label class="form-label"
                                                        for="basic-icon-default-language_code">{{__('lang.admin_holiday_date_range')}}</label>
                                                    <input type="text" id="fp-range"
                                                        class="form-control flatpickr-range"
                                                        placeholder="YYYY-MM-DD to YYYY-MM-DD" name="date_range"
                                                        value="{{$date_range}}" />
                                                </div>
                                                <div class="mb-1">
                                                    <label class="form-label"
                                                        for="basic-icon-default-language_code">{{__('lang.admin_description')}}</label>
                                                    <input type="text" id="basic-icon-default-language_code"
                                                        class="form-control dt-discount_price" placeholder="{{__('lang.admin_description')}}"
                                                        name="description"
                                                        value="{{ isset($res->description)?$res->description:'--' }}" />
                                                </div>
                                                <button type="submit"
                                                    class="btn btn-primary data-submit me-1">{{__('lang.admin_button_update')}}</button>
                                                <button type="reset" class="btn btn-outline-secondary"
                                                    data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
                                            </div>
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                    @else
                                    <?php echo '-';?>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>