<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_day_delivery_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>
                                    <div class="checkbox  checkbox-primary" style="    margin-bottom: 0px;">
                                        <input id="checkbox2" type="checkbox" name="check_all" onchange="checkAll(this)" class="check_all" >
                                        <label for="checkbox2"></label>
                                    </div>
                                </th>
                                <th>{{__('lang.admin_order_id')}}</th>
                                <th>{{__('lang.admin_user_phone')}}</th>
                                <th>{{__('lang.admin_product_name')}}</th>
                                <th>{{__('lang.admin_order_quantity')}}</th>
                                <th>{{__('lang.admin_total_amnt')}}</th>
                                <th>Driver Status</th>
                                <th>{{__('lang.admin_delivery_status')}}</th>
                                <th>{{__('lang.admin_order_delivery_date')}}</th>
                                <th>{{__('lang.admin_order_date')}}</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td>
                                    <div class="checkbox  checkbox-primary">
                                        <input id="checkbox1" class="cb" type="checkbox" name="order_id[]" value="{{$res->id}}">
                                        <label for="checkbox1"></label>
                                    </div>
                                </td>
                                <td><a title="Order Detail" href="{{ route('orders.show', $res->order_id)}}" target="_blank">#{{$res->order_id}}</a></td>
                                <td>{{ isset($res->user)?$res->user->phone:'--' }}</td>
                                <td><a title="Product Detail" href="{{ route('products.edit', $res->product_id)}}" target="_blank">{{($res->product_orders)?($res->product_orders->product)?$res->product_orders->product->name:'--':'--'}}</a></td>
                                <td>{{ isset($res->product_orders) ? $res->product_orders->quantity : '--' }}</td>
                                <td>{{ isset($res->product_orders) ? \Helpers::currency($res->product_orders->total_delivery_amount) : '--' }}</td>
                                <td>                                   
                                    <select class="form-select" id="driver_{{$res->id}}" name="driver_{{$res->id}}" title="Order Status" onchange="doAssignDrivers('{{$res->id}}',this.value)">
                                        <option value="">Select Driver</option>
                                        @foreach ($filter['drivers'] as $row)
                                            <option value="{{$row->id}}" @if($row->id==$res->driver_id) selected @endif>{{$row->name}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    @if($res->order_status_id==6)
                                        {{ isset($res->delivery_status) ? $res->delivery_status->status : '--' }}
                                    @else
                                        <select class="form-select" id="order_status_{{$res->id}}" name="order_status_{{$res->id}}" title="Order Status" onchange="doUpdateProductOrderStatus('{{$res->id}}',this.value)">
                                        @foreach ($filter['order_status'] as $row)
                                            <option value="{{$row->id}}" @if($row->id==$res->order_status_id) selected @endif>{{$row->status}}</option>
                                        @endforeach
                                        </select>
                                    @endif
                                </td>
                                <td>{{ isset($res->delivery_date) ? \Helpers::commonDateFormate($res->delivery_date) : '--' }}</td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('orders.show', $res->order_id) }}" target="_blank">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span>{{__('lang.admin_button_detail')}}</span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="9" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div style="float:left;">
                        <select style="width: 300px;" class="form-select" id="drivers" name="drivers" title="Order Status" onchange="doBulkAssignDrivers(this.value)">
                            <option value="">Select Driver</option>
                            @foreach ($filter['drivers'] as $row)
                                <option value="{{$row->id}}" @if($row->id==$res->driver_id) selected @endif>{{$row->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>

<script type="text/javascript">
     function checkAll(that) {
        $('.cb').prop("checked", that.checked);
     }
    function doUpdateProductOrderStatus(id,val) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var data = {
            'order_item_id' : id,
            'order_status_id' : val
        };
        $.ajax({
            type: 'post',
            url: base_url + '/admin/update-delivery-status',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.options =
                    {
                        "closeButton" : true,
                        "progressBar" : true
                    }
                    toastr.success(response.message);
                    if(val==6){
                        window.location.reload();
                    }
                }
            }
        });
    }

    function doAssignDrivers(id,val) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var data = {
            'order_item_id' : id,
            'driver_id' : val
        };
        $.ajax({
            type: 'post',
            url: base_url + '/admin/assign-driver',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.options =
                    {
                        "closeButton" : true,
                        "progressBar" : true
                    }
                    toastr.success(response.message);
                    if(val==6){
                        window.location.reload();
                    }
                }
            }
        });
    }

    function doBulkAssignDrivers(val) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var data = {
            'order_item_id' : [],
            'driver_id' : val
        };
        var cboxes = document.getElementsByName('order_id[]');
        var len = cboxes.length;
        for (var i=0; i<len; i++) {
            if(cboxes[i].checked){
                data.order_item_id.push(cboxes[i].value)
            }
        }
        data.order_item_id = data.order_item_id.toString();
        $.ajax({
            type: 'post',
            url: base_url + '/admin/bulk-assign-driver',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.options =
                    {
                        "closeButton" : true,
                        "progressBar" : true
                    }
                    toastr.success(response.message);
                    if(val==6){
                        window.location.reload();
                    }
                }
            }
        });
    }
</script>