@extends('layouts.site-app') @section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>

    <div class="inner-heading">{{__('lang.wallet_title')}}</div>
</section>

<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-11">
                @if(Session::has('error'))

                <div class="alert alert-danger" role="alert">
                    {{ Session::get('error') }}
                </div>

                @endif 

                    <div class="chooselocation mt-4 selectlocation">
                        <span><img src="{{asset('site-assets/images/payment-icon.png')}}" /></span>

                        {{__('lang.Payment_method')}}
                    </div>
                    @if(setting('enable_razorpay')=='1')
                    <div class="select-address paymentmethod">
                        <div class="custom-control custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio3" name="payment_method" value="razorpay" checked/>
                            <label class="custom-control-label" for="customRadio3"> {{__('lang.pay_using_razorpay')}}</label>
                        </div>
                    </div>
                    @endif
                    <div class="cart-total-box">
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label> {{\Helpers::currency($post['amount'])}}</p>
                    <form action="{{url('wallet-payment-confirm')}}" method="post">
                    @csrf
                        <script
                            src="https://checkout.razorpay.com/v1/checkout.js"
                            data-key="{{setting('razorpay_key')}}"
                            data-amount="{{$post['amount']*100}}"
                            data-currency="INR"                
                            data-theme.color="#14a1a7",
                            data-button_text = "{{__('lang.place_order_button')}}"
                            data-button_theme = "submit-btn mt-3"
                        ></script>
                    </div>
                    <input type="hidden" name="paymentid" id="paymentid" value="{{$post['paymentid']}}"> 
                    <input type="hidden" name="payment_method" id="payment_method" value="razorpay"> 
                </form>
            </div>
        </div>
    </div>
</section>

<footer class="footer">
    @include('partials.site.footer')
</footer>

<!-- END: Content-->

@endsection


<style type="text/css">
    .razorpay-payment-button{
        background: #af7ab3;
        color: #fff;
        padding: 0px;
        display: inline-block;
        font-size: 14px;
        font-family: Helvetica-Bold, Helvetica, sans-serif;
        border: none;
        border-radius: 40px;
        height: 60px;
        line-height: 60px;
        padding: 0px 25px;
        width: 100%;
    }
    .razorpay-payment-button:hover {
        background: #06283d;
    }
</style>