@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_product_translation')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/products*') ? 'active' : '' }}"><a href="{!! route('products.index') !!}">{{__('lang.admin_product_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_product_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="language_code">{{__('lang.admin_select_language')}}</label>
                                            <select class="form-select" id="language_code" name="language_code" onchange="selectLanguage(this.value);" required>
                                                @foreach($languages as $row)
                                                    <option value="{{$row->language_code}}">{{$row->language_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                {!! Form::model($data, ['method' => 'POST','url' => ['admin/products/translation/'.$data->id]]) !!}
                                @csrf
                                <?php
                                $i = 0;
                                ?>
                                @foreach($languages as $row) @if($row->details)
                                    <input type="hidden" name="translation_id[]" value="{{$row->details->id}}">
                                    <input type="hidden" name="language_code[]" value="{{$row->language_code}}">
                                    <div class="row formbody <?php if($i>0){ ?>hide<?php } ?>" id="translation_{{$row->language_code}}">
                                        <div class="col-md-6">
                                            <div class="mb-1">
                                                <label class="form-label" for="description">{{__('lang.admin_description')}} ({{$row->language_name}})</label>
                                                <textarea class="form-control flatpickr-basic" placeholder="{{__('lang.admin_description')}}" name="description[]" id="description">{{$row->details->description}}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $i++; ?>
                                @endif @endforeach
                                <div class="row">
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('products.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- coupons edit ends -->

        </div>
    </div>
</div>
<!-- END: Content-->
<script type="text/javascript">
    function selectLanguage(langCode){
        $(".formbody").addClass('hide');
        $("#translation_"+langCode).removeClass('hide');
    }
</script>
@endsection