@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_payment_gateway')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf
                            <div class="col-xl-12 col-lg-12">
                                <ul class="nav nav-pills nav-justified">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="home-tab-justified" data-bs-toggle="pill" href="#home-justified" aria-expanded="true">Stripe</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="profile-tab-justified" data-bs-toggle="pill" href="#profile-justified" aria-expanded="false">EGHL</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="about-tab-justified" data-bs-toggle="pill" href="#about-justified" aria-expanded="false">Razorpay</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div role="tabpanel" class="tab-pane active" id="home-justified" aria-labelledby="home-tab-justified" aria-expanded="true">
                                        <div class="row">
                                            @foreach ($data as $row)
                                                <!-- @if($row->key=='enable_stripe')
                                                <div class="form-group row col-12">
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="enable_stripe">Enable Stripe</label>
                                                            <input type="checkbox" placeholder="Stripe key" name="enable_stripe" id="enable_stripe" value="1"  <?php if($row->value){?>checked<?php } ?>/>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif -->
                                                @if($row->key=='stripe_key')
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="stripe_key">Stripe Key</label>
                                                            <input type="text" class="form-control" placeholder="Stripe key" name="stripe_key" id="stripe_key" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                                @if($row->key=='stripe_secret')
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="stripe_secret">Stripe Secret</label>
                                                            <input type="text" class="form-control" placeholder="Stripe Secret" name="stripe_secret" id="stripe_secret" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                            <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                                <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="profile-justified" role="tabpanel" aria-labelledby="profile-tab-justified" aria-expanded="false">
                                        <div class="row">
                                            @foreach ($data as $row)
                                                <!-- @if($row->key=='enable_eghl')
                                                <div class="form-group row col-12">
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="enable_eghl">Enable EGHL</label>
                                                            <input type="checkbox" placeholder="Enable EGHL" name="enable_eghl" id="enable_eghl" value="1" <?php if($row->value){?>checked<?php } ?> />
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif -->
                                                @if($row->key=='eghl_serviceid')
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="eghl_serviceid">EGHL Service id</label>
                                                            <input type="text" class="form-control" placeholder="EGHL Service id" name="eghl_serviceid" id="eghl_serviceid" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                                @if($row->key=='eghl_password')
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="eghl_password">EGHL Password</label>
                                                            <input type="text" class="form-control" placeholder="EGHL Password" name="eghl_password" id="eghl_password" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                            <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                                <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="about-justified" role="tabpanel" aria-labelledby="about-tab-justified" aria-expanded="false">
                                        <div class="row">
                                            @foreach ($data as $row)
                                                <!-- @if($row->key=='enable_razorpay')
                                                <div class="form-group row col-12">
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="enable_razorpay">Enable Razorpay</label>
                                                            <input type="checkbox" placeholder="Enable Razorpay" name="enable_razorpay" id="enable_razorpay" value="1"  <?php if($row->value){?>checked<?php } ?>/>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif -->
                                                @if($row->key=='razorpay_key')
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="razorpay_key">Razorpay Key</label>
                                                            <input type="text" class="form-control" placeholder="Razorpay Key" name="razorpay_key" id="razorpay_key" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                                @if($row->key=='razorpay_secret')
                                                    <div class="col-md-6">
                                                        <div class="mb-1">
                                                            <label class="form-label" for="razorpay_secret">Razorpay Secret</label>
                                                            <input type="text" class="form-control" placeholder="Razorpay Secret" name="razorpay_secret" id="razorpay_secret" value="{{$row->value}}" />
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                            <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                                <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- {!! Form::close() !!} --}}
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection