<!-- Basic table -->
<section id="responsive-datatable">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title">{{__('lang.admin_cms_page')}}</h4>
                </div>
                <div class="card-datatable">
                    <table class="dt-responsive table">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_page_name')}}</th>
                                <th>{{__('lang.admin_title')}}</th>
                                <th>{{__('lang.admin_description')}}</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td><a href="{{ route('site_contents.edit', $res->id) }}">{{ucwords($res->page_name)}}</a></td>
                                <td>{{$res->page_title}}</td>
                                <td><?php echo substr(strip_tags($res->description),0,300); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('site_contents.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            <a class="dropdown-item" href="{{ url('admin/site_contents/translation/'.$res->id) }}">
                                                <i data-feather="type" class="me-50"></i>
                                                <span>{{__('lang.admin_button_translation')}}</span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="3" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>