@extends('layouts.site-app')
@section('sitecontent')
<?php
$disabledWeekDays = array();
$highlightedDates = array();
foreach ($holdaysDate as $rows) {
    $temp = array(
        'start' => date("Y-m-d",strtotime($rows->start_date)),
        'end' => date("Y-m-d",strtotime($rows->end_date))
    );
    array_push($disabledWeekDays, $temp);

    $i = 0;
    $startDate = $rows->start_date;
    do{
        $currentDate = date("Y-m-d",strtotime($startDate.' + '.$i.' day'));
        $tempAr = array(
            'date' => $currentDate,
            'highlight' => 'red',
            'markCssClass' => 'square-mark'
        );
        array_push($highlightedDates, $tempAr);
        $i++;
    }while(strtotime($currentDate)<strtotime($rows->end_date));
}


?>
<script>
    var  mobiscrollObj = [];
    var weekDays = '<?php echo json_encode($disabledWeekDays); ?>';
    weekDays = JSON.parse(weekDays);
    var highlightedDates = '<?php echo json_encode($highlightedDates); ?>';
    highlightedDates = JSON.parse(highlightedDates);
    var invalidObj = weekDays;
</script>
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.cart_title')}}</div>
</section>
<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            @if(count($data)>0)
                @if(Session::has('message'))
                    <div class="col-lg-11">
                        <div class="alert alert-success" role="alert">
                          {{ Session::get('message') }}
                        </div>
                    </div>
                @endif
                @if(Session::has('error'))
                <div class="col-lg-11">
                    <div class="alert alert-danger" role="alert">
                      {{ Session::get('error') }}
                    </div>
                </div>
                @endif
            @endif

            <div class="col-lg-11">
                @if(count($data)>0)
                    {!! Form::model(null, ['method' => 'POST', 'url' => ['cart-checkout']]) !!}
                        @csrf
                        @foreach($data as $row)
                            @if($row->product)
                                <div class="inforow">
                                    <input type="hidden" name="cart_id[]" value="{{$row->id}}">
                                    <input type="hidden" id="product_min_qty_{{$row->id}}" value="{{($row->product->minimum_order_quantity>0)?$row->product->minimum_order_quantity:1}}">
                                    <span class="productimg"><img src="{{asset('app-assets/images/products')}}/{{$row->product->image}}" alt="{{$row->name}}" /></span>
                                    <span class="productname">{{$row->product->name}}</span>
                                    <span class="productname">{{\Helpers::currency($row->total_delivery_amount)}}</span>
                                    <span class="productnumber">
                                        <button data-action="decrement" class="decrbtn" type="button">
                                            <span class="m-auto text-2xl font-thin">−</span>
                                        </button>
                                        <input type="number" name="quantity[]" value="{{$row->quantity}}" id="{{$row->id}}" readonly />
                                        <button data-action="increment" class="decrbtn" type="button">
                                            <span class="m-auto text-2xl font-thin">+</span>
                                        </button>
                                    </span>
                                    <div class="editdeletebtns">
                                        <a href="{{url('delete-cart-item')}}/{{$row->id}}" title="{{__('lang.delete_cart_item')}}" style="background: #af7ab3;"><img src="{{asset('site-assets/images/icondele1.svg')}}"  /></a>
                                        <a href="javascript:;" onclick="enableCalculation();" data-toggle="collapse" data-target="#tab_{{$row->id}}" title="{{__('lang.edit_cart')}}"><img src="{{asset('site-assets/images/edit01.svg')}}"  /></a>
                                    </div>
                                </div>
                                <div class="calenderbg-outer collapse" id="tab_{{$row->id}}">
                                    <div class="calenderbg addressform calenderradio">
                                        <div class="calenderradio02 radio">
                                            <input type="radio" id="once_{{$row->id}}" onclick="selectFrequency('once','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Once" @if($row->order_frequency=='once') checked @endif/>
                                            <input type="radio" id="daily_{{$row->id}}" onclick="selectFrequency('daily','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Daily"  @if($row->order_frequency=='daily') checked @endif/>
                                            <input type="radio" id="weekly_{{$row->id}}" onclick="selectFrequency('weekly','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Weekly"  @if($row->order_frequency=='weekly') checked @endif/>
                                            <input type="radio" id="monthly_{{$row->id}}" onclick="selectFrequency('monthly','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Monthly"  @if($row->order_frequency=='monthly') checked @endif/>
                                            <input type="radio" id="alternative_{{$row->id}}" onclick="selectFrequency('alternative','{{$row->id}}');" name="order_frequency_{{$row->id}}" value="Alternative"  @if($row->order_frequency=='alternative') checked @endif/>
                                        </div>
                                        <div class="weeklydays @if($row->order_frequency!='weekly') hide @endif days_option_{{$row->id}}">
                                            <h3>{{__('lang.select_days_for_delivery')}}</h3>
                                            <div class="radio">
                                                <?php
                                                $days = explode(",",$row->days);
                                                ?>
                                                <input type="checkbox" id="days_sun_{{$row->id}}" name="days_{{$row->id}}[sun]" value="S"  @if(in_array(0,$days)) checked @endif/>

                                                <input type="checkbox" id="days_mon_{{$row->id}}" name="days_{{$row->id}}[mon]" value="M"  @if(in_array(1,$days)) checked @endif/>
                                                <input type="checkbox" id="days_tue_{{$row->id}}" name="days_{{$row->id}}[tue]" value="T"  @if(in_array(2,$days)) checked @endif/>
                                                <input type="checkbox" id="days_wed_{{$row->id}}" name="days_{{$row->id}}[wed]" value="W"  @if(in_array(3,$days)) checked @endif/>
                                                <input type="checkbox" id="days_thu_{{$row->id}}" name="days_{{$row->id}}[thu]" value="T"  @if(in_array(4,$days)) checked @endif/>
                                                <input type="checkbox" id="days_fri_{{$row->id}}" name="days_{{$row->id}}[fri]" value="F"  @if(in_array(5,$days)) checked @endif/>
                                                <input type="checkbox" id="days_sat_{{$row->id}}" name="days_{{$row->id}}[sat]" value="S"  @if(in_array(6,$days)) checked @endif/>
                                            </div>
                                        </div>
                                        <div class="quickselection @if($row->order_frequency!='weekly') hide @endif days_option_{{$row->id}}">
                                            <div class="radio">
                                                <span>{{__('lang.quick_selection')}}</span>
                                                <input type="radio" id="weekday_{{$row->id}}" name="quick[]" onclick="selectQuickSelection('WEEKDAYS','{{$row->id}}');" value="{{__('lang.weekdays')}}" />
                                                <input type="radio" id="weekends_{{$row->id}}" name="quick[]" onclick="selectQuickSelection('WEEKENDS','{{$row->id}}');" value="{{__('lang.weekend')}}" />
                                            </div>
                                        </div>
                                        <div class="calenderbox">
                                            <h3>{{__('lang.select_deliver_date')}}</h3>
                                            <?php
                                            $date = $row->start_date. ' - '.$row->end_date;
                                            if($row->order_frequency=='once'){
                                                $date = $row->start_date;
                                            }
                                            if($row->order_frequency=='monthly'){
                                                $date = $row->delivery_dates;
                                            }
                                            ?>
                                            <input type="hidden" class="demo-multi-day" id="delivery_dates_{{$row->id}}" name="delivery_dates[]" value="{{$date}}" required>
                                        </div>
                                    </div>
                                    <?php if($row->order_frequency=='once'){ ?>
                                        <script type="text/javascript">
                                            var currentDate = new Date();
                                            currentDate.setDate(currentDate.getDate() + 1);
                                            mobiscrollObj[<?php echo $row->id; ?>] = mobiscroll.setOptions({
                                                locale: mobiscroll.localeEn, // Specify language like: locale: mobiscroll.localePl or omit setting to use default
                                                theme: "ios", // Specify theme like: theme: 'ios' or omit setting to use default
                                                themeVariant: "light", // More info about themeVariant: https://docs.mobiscroll.com/5-7-1/calendar#opt-themeVariant
                                            });
                                            $("#delivery_dates_<?php echo $row->id; ?>")
                                            .mobiscroll()
                                            .datepicker({
                                                controls: ["calendar"],                                                
                                                invalid: invalidObj,
                                                colors : highlightedDates,
                                                display: "inline",
                                                min: currentDate
                                            });
                                        </script>
                                    <?php }else if($row->order_frequency=='monthly'){ ?>
                                        <script type="text/javascript">
                                            var currentDate = new Date();
                                            currentDate.setDate(currentDate.getDate() + 1);
                                            mobiscrollObj[<?php echo $row->id; ?>] = mobiscroll.setOptions({
                                                locale: mobiscroll.localeEn, // Specify language like: locale: mobiscroll.localePl or omit setting to use default
                                                theme: "ios", // Specify theme like: theme: 'ios' or omit setting to use default
                                                themeVariant: "light", // More info about themeVariant: https://docs.mobiscroll.com/5-7-1/calendar#opt-themeVariant
                                            });
                                            $("#delivery_dates_<?php echo $row->id; ?>")
                                            .mobiscroll()
                                            .datepicker({
                                                controls: ["calendar"],                                                
                                                invalid: invalidObj,
                                                marked : highlightedDates,
                                                display: "inline",
                                                selectMultiple: true,
                                                min: currentDate
                                            });
                                        </script>
                                    <?php }else{ ?>
                                        <script type="text/javascript">
                                            var currentDate = new Date();
                                            currentDate.setDate(currentDate.getDate() + 1);
                                            mobiscrollObj[<?php echo $row->id; ?>] = mobiscroll.setOptions({
                                                locale: mobiscroll.localeEn, // Specify language like: locale: mobiscroll.localePl or omit setting to use default
                                                theme: "ios", // Specify theme like: theme: 'ios' or omit setting to use default
                                                themeVariant: "light", // More info about themeVariant: https://docs.mobiscroll.com/5-7-1/calendar#opt-themeVariant
                                            });
                                            $("#delivery_dates_<?php echo $row->id; ?>")
                                            .mobiscroll()
                                            .datepicker({
                                                controls: ["calendar"],
                                                display: "inline",
                                                select:'range',
                                                marked : highlightedDates,
                                                showRangeLabels: false,
                                                selectMultiple: true,
                                                min: currentDate
                                            });
                                        </script>
                                    <?php } ?>
                                </div>
                            @endif
                        @endforeach
                        <div class="cart-total-box calculation">
                            <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                            <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                            <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                            <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} <br><a href="#" data-toggle="modal" data-target="#coupon">{{__('lang.change_coupon_btn')}}</a> @else <a href="#" data-toggle="modal" data-target="#coupon">{{__('lang.apply_coupon_btn')}}</a>  @endif </p>
                            <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>
                            <p><button class="submit-btn mt-3 full-width-btn" type="submit" name="submit_button" value="next">{{__('lang.next_btn')}} <img src="{{asset('site-assets/images/arrowright.png')}}"/></button></p>
                        </div>
                        <div class="cart-total-box hide calculate">
                            <p><button class="submit-btn mt-3 full-width-btn" type="submit" name="submit_button" value="recalculate">{{__('lang.re_calculate_btn')}} <img src="{{asset('site-assets/images/arrowright.png')}}"/></button></p>
                        </div>
                    {!! Form::close() !!}
                @else
                    <div class="alert alert-danger" role="alert">
                      {{__('lang.not_any_item_in_cart')}}
                    </div>
                    <p style="text-align: center;">
                        <?php
                        $url = url('/#populargoods');
                        ?>
                        <button class="col-lg-3 submit-btn mt-3 full-width-btn" type="button" onclick="window.location.href='{{$url}}'">{{__('lang.navigation_home')}}</button>
                    </p>
                @endif
            </div>
        </div>
    </div>
</section>
@include('partials.site.coupon')
<footer class="footer">
    @include('partials.site.footer')
</footer>
@endsection