@extends('layouts.site-app')
@section('sitecontent')
<style type="text/css">
    .nextbtn{
        /* width: auto; */
    }
</style>
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.checkout_title')}}</div>
</section>
<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-11">
                @include('partials.site.alert')
                <div class="chooselocation selectlocation">
                    <span><img src="{{asset('site-assets/images/chooseloacation.png')}}"  /></span>
                    {{__('lang.select_location')}}
                </div>
                <div class="add-address">
                    <a href="javascript:;" onclick="showAddressForm()"><img src="{{asset('site-assets/images/plusico.png')}}" style="width: 30%;" /></a> <span onclick="showAddressForm()" style="cursor: pointer;">{{__('lang.add_address')}}</span>
                </div>
                <div class="addressformbg" id="addAddressForm" style="display: none">
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="map">
                                <div id="myMap" style="height: 600px;width: 100%;position: relative;overflow: hidden;border: 1px solid #a5a5a5;border-radius: 5px;margin-bottom: 5px"></div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="addressform">
                                {!! Form::model(null, ['method' => 'POST', 'url' => ['add-address']]) !!}
                                    @csrf
                                    <input type="hidden" name="location_name" id="location_name" value="">
                                    <input type="hidden" name="latitude" id="latitude" value="28.644800">
                                    <input type="hidden" name="longitude" id="longitude" value="77.216721">
                                    <input type="hidden" name="city" id="city">
                                    <input type="hidden" name="state" id="state">
                                    <input type="hidden" name="zipcode" id="zipcode">
                                    <input type="hidden" name="country" id="country">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.address_detact_location')}}</label>
                                            <input type="text" class="form-control" name="google_address" id="google_address"    placeholder="{{__('lang.address_detact_location')}}"/>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.address_type')}}</label>
                                            <div class="radio">
                                                <input label="" type="radio" id="Home" name="type" value="{{__('lang.address_home')}}" checked />
                                                <input label="" type="radio" id="Office" name="type" value="{{__('lang.address_office')}}" />
                                                <input label="" type="radio" id="Mosque" name="type" value="{{__('lang.address_mosque')}}" />
                                                <input label="" type="radio" id="other" name="type" value="{{__('lang.address_other')}}" />
                                            </div>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.address_title')}}</label>
                                            <input type="text" class="form-control" name="address" placeholder="{{__('lang.address_title')}}" />
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.placeholder_note')}}</label>
                                            <textarea class="form-control" name="note" id="note" style="height: 70px;" placeholder="{{__('lang.placeholder_note')}}" ></textarea>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <button class="save-btn text-uppercase float-right" type="submit">{{__('lang.save_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                            <button type="button" onClick="hideAddressForm();" class="save-btn text-uppercase float-left" style="background: #af7ab3;">{{__('lang.cancel_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                        </div>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
                {!! Form::model(null, ['method' => 'GET', 'url' => ['place-order']]) !!}
                    @csrf
                    <div class="select-address">
                        @if(count($data)>0)
                            @foreach($data as $row)
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input" name="delivery_address_id" value="{{$row->id}}" id="customRadio_{{$row->id}}" name="selectaddress">
                                    <label class="custom-control-label" for="customRadio_{{$row->id}}"> <span>{{$row->type}} @if($row->location_name!='')({{$row->location_name}})@endif</span> @if($row->address!='') {{$row->address}}, @endif  @if($row->city!='') {{$row->city}}, @endif  @if($row->state!='') {{$row->state}}, @endif {{$row->zipcode}}</label>
                                    <a onclick="return confirm('Are you sure you want to delete this address?');" class="checkouts" href="{{url('/delete-address')}}/{{$row->id}}"><img src="images/icon-trash.svg" alt=""></a>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="nextbtn">
                        <button class="save-btn text-uppercase float-left full-width-btn" type="submit">{{__('lang.next_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1"/></button>
                    </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</section>
<footer class="footer">
    @include('partials.site.footer')
</footer>
<script type="text/javascript">
    setTimeout(function(){
        getLocation();
    },1500);
</script>

<!-- END: Content-->

@endsection