<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">{{__('lang.admin_contact_us_list')}}</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th>{{__('lang.admin_menu_users')}}</th>
                               <th>{{__('lang.admin_email')}}</th>
                               <th>{{__('lang.admin_mobile')}}</th>
                               <th>{{__('lang.admin_message')}}</th>
                               <th>{{__('lang.admin_date')}}</th>
                               <th>{{__('lang.admin_status')}}</th>
                               <th>{{__('lang.admin_table_action')}}</th>
                           </tr>
                       </thead>
                       <tbody>
                           @if(count($data) > 0)
                           @foreach($data as $res)
                           <tr>
                                <td>{{ isset($res->name)?$res->name:'--' }}</td>
                                <td>{{ isset($res->email)?$res->email:'--' }}</td>
                                <td>{{ isset($res->mobile)?$res->mobile:'--' }}</td>
                                <td>{{ isset($res->message)?$res->message:'--' }}</td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateFormate($res->created_at) : '--' }}</td>
                                <td>@if($res->is_replied == 1)
                                    <span class="badge rounded-pill badge-light-success me-1">{{__('lang.admin_replied')}}</span>
                                    @else 
                                    --
                                    @endif
                                </td>
                                <td>
                                    <a data-bs-toggle="modal" data-bs-target="#modals-slide-in_{{$res->id}}" data-placement="bottom" title="{{__('lang.admin_reply')}}" class='on-default edit-row margin-3'>
                                        <i data-feather="send" class="me-50"></i>
                                    </a>
                                    <div class="modal modal-slide-in fade" id="modals-slide-in_{{$res->id}}">
                                        <div class="modal-dialog sidebar-sm">
                                            <form class="add-new-record modal-content pt-0" action="{!! route('contact_us.store') !!}" enctype="multipart/form-data" method="post">
                                                <input type="hidden" class="form-control dt-full-name" aria-label="Contact" name="contact_id" value="{{ $res->id }}"/>
                                                @csrf
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                                <div class="modal-header mb-1">
                                                    <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_reply')}}</h5>
                                                </div>
                                                <div class="modal-body flex-grow-1">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_user_name')}}</label>
                                                        <input type="text" class="form-control dt-full-name"  id="basic-icon-default-fullname" placeholder="{{__('lang.admin_name')}}" aria-label="{{__('lang.admin_name')}}" name="name" value="{{ isset($res->name)?$res->name:'--' }}"/>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="basic-icon-default-discount_price">{{__('lang.admin_email')}}</label>
                                                        <input type="email" id="basic-icon-default-discount_price" class="form-control dt-discount_price" placeholder="{{__('lang.admin_email')}}" aria-label="{{__('lang.admin_email')}}" name="email" value="{{ isset($res->email)?$res->email:'--' }}" />
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="message">{{__('lang.admin_message')}}</label>
                                                        <textarea id="fp-default" class="form-control flatpickr-basic" placeholder="{{__('lang.admin_message')}}" aria-label="{{__('lang.admin_message')}}" name="message"></textarea>
                                                    </div>
                                                    <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                </td>
                           </tr>
                           @endforeach
                           @else
                           <tr>
                               <td colspan="6" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                           </tr>
                           @endif
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
