<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">{{__('lang.admin_keyword_list')}}</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                                <th>{{__('lang.admin_keyword_group')}}</th>
                                <th>{{__('lang.admin_keyword_name')}}</th>
                                <th>{{__('lang.admin_keyword_value')}}</th>
                                <th>{{__('lang.admin_keyword_lang_code')}}</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                           </tr>
                       </thead>
                       <tbody>
                           @if(count($data) > 0)
                           @foreach($data as $res)
                           <tr>
                                <td>{{ isset($res->group)?$res->group:'--' }}</td>
                                <td>{{ isset($res->keyword)?$res->keyword:'--' }}</td>
                                <td><?php echo $res->value; ?></td>
                                <td>{{ isset($res->lang_code)?$res->lang_code:'--' }}</td>
                                <td>
                                    <a href="{{ route('keywords.edit', $res->keyword) }}">
                                        <i data-feather="edit-2" class="me-50"></i>
                                    </a>
                                </td>
                           </tr>
                           @endforeach
                           @else
                           <tr>
                               <td colspan="6" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                           </tr>
                           @endif
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
