<table class="table table-striped">
    <thead>
        <tr>
            <th>{{__('lang.admin_order_id')}}</th>
            <th>{{__('lang.admin_user_phone')}}</th>
            <th>{{__('lang.admin_order_status')}}</th>
            <th>{{__('lang.admin_amount')}}</th>
            <th>{{__('lang.admin_coupon_code')}}</th>
            <th>{{__('lang.admin_method')}}</th>
            <th>{{__('lang.admin_payment_status')}}</th>
            <th>{{__('lang.admin_date')}}</th>
        </tr>
    </thead>
    <tbody>
        @if(count($data) > 0)
        @foreach($data as $res)
        <tr>
            <td><a title="Order Detail" href="{{ route('orders.show', $res->id)}}">#{{$res->id}}</a></td>
            <td>{{ isset($res->user)?$res->user->phone:'--' }}</td>
            <td>{{ isset($res->order_status) ? $res->order_status->status : '--' }}</td>
            <td>{{ isset($res->final_amount) ? \Helpers::currency($res->final_amount) : '--' }}</td>
            <td>{{ isset($res->coupon_code) ? $res->coupon_code : '--' }}</td>
            <td style="text-transform: capitalize;">{{ isset($res->payment_method) ? $res->payment_method : '--' }}</td>
            <td>{{ isset($res->payment) ? $res->payment->status : '--' }}</td>
            <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
        </tr>
        @endforeach
        @else
        <tr>
            <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
        </tr>
        @endif
    </tbody>
</table>