@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}" />

<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-12 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_revenue')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_revenue_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
                <div class="dt-action-buttons text-end">
                    <form id="formData" method="get">
                        <div class="row">
                            <div class="form-group col-sm-7">
                                <input type="text" name="date_filter" class="form-control flat-picker" placeholder="Order Date" id="reportrange" @if(isset($_GET['date_filter'])) value="{{$_GET['date_filter']}}" @endif>
                            </div>
                            <div class="form-group col-sm-5">
                                <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                                <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                                <a href="{{ url('admin/revenue-report-export') }}" class="btn btn-info"><i data-feather="download"></i></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            @include('orders.revenue_table')
        </div>
    </div>
</div>

<script type="text/javascript">
    var flatPicker = $(".flat-picker");
    var date = new Date();
    flatPicker.each(function () {
        $(this).flatpickr({
            mode: "range"
        });
    });
</script>
<!-- END: Content-->
@endsection