@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_products')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                    </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_product_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-3 col-12 d-md-block">
                <div class="mb-1 breadcrumb-right">
                    <button class="btn btn-icon btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#modals-slide-in">
                        <i data-feather="plus" class="me-25"></i>
                        <span>{{__('lang.admin_product_add')}}</span>
                    </button>
                </div>
            </div>
            @include('products.table')
        </div>
    </div>
</div>
<!-- Modal to add new record -->
<div class="modal modal-slide-in fade" id="modals-slide-in">
    <div class="modal-dialog sidebar-sm">
        <form class="add-new-record modal-content pt-0" action="{!! route('products.store') !!}" enctype="multipart/form-data" method="post">
            @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{__('lang.admin_product_new')}}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                    <div class="col-12 d-flex mt-1 px-0">
                        <label class="btn btn-primary me-75 mb-0" for="change-picture">
                            <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                            <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                            <span class="d-block d-sm-none">
                                <i class="me-0" data-feather="edit"></i>
                            </span>
                        </label>
                    </div>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-fullname">{{__('lang.admin_product_name')}}<span class="required">*</span></label>
                    <input type="text" class="form-control dt-full-name" id="basic-icon-default-fullname" placeholder="{{__('lang.admin_product_name')}}" aria-label="{{__('lang.admin_product_name')}}" name="name" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-price">{{__('lang.admin_price')}} <span class="required">*</span></label>
                    <input type="number" id="basic-icon-default-price" class="form-control dt-price" placeholder="{{__('lang.admin_price')}}" aria-label="{{__('lang.admin_price')}}" name="price" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" required/>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-discount_price">{{__('lang.admin_discount_price')}}</label>
                    <input type="text" id="basic-icon-default-discount_price" class="form-control dt-discount_price" placeholder="{{__('lang.admin_discount_price')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" aria-label="{{__('lang.admin_discount_price')}}" name="discount_price" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-minimum_order_quantity">{{__('lang.admin_min_purchase_qty')}}</label>
                    <input type="text" id="basic-icon-default-minimum_order_quantity" class="form-control dt-minimum_order_quantity" placeholder="{{__('lang.admin_min_purchase_qty')}}" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" aria-label="{{__('lang.admin_min_purchase_qty')}}" name="minimum_order_quantity" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-description">{{__('lang.admin_description')}}</label>
                    <textarea id="basic-icon-default-description" class="form-control dt-post" placeholder="{{__('lang.admin_description')}}" aria-label="{{__('lang.admin_description')}}" name="description"></textarea>
                </div>
                <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_submit')}}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button>
            </div>
        </form>
    </div>
</div>
<!-- END: Content-->
@endsection